/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.common.config;

import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class EntityConfig {
    private final ForgeConfigSpec.ConfigValue<Boolean> active;
    private final ForgeConfigSpec.ConfigValue<Integer> spawnWeight;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> biomes;
    public boolean shouldExist;
    public int spawnRate;
    public List<? extends String> spawnBiomes;

    public EntityConfig(ForgeConfigSpec.ConfigValue<Boolean> act, ForgeConfigSpec.ConfigValue<Integer> spawn, ForgeConfigSpec.ConfigValue<List<? extends String>> biome) {
        this.active = act;
        this.spawnWeight = spawn;
        this.biomes = biome;
    }

    public void bake() {
        this.shouldExist = (Boolean)this.active.get();
        this.spawnRate = (Integer)this.spawnWeight.get();
        this.spawnBiomes = (List)this.biomes.get();
    }

    public static EntityConfig createConfigForEntity(ForgeConfigSpec.Builder builder, String name, Boolean dfActive, int dfWeight, List<String> dfBiomes) {
        ForgeConfigSpec.ConfigValue active = builder.comment("This defines whether or not the " + name + "s should exist (default: " + dfActive + ", when changing this to false EVERY entity of this type will be deleted!)").translation("cnb.configgui." + name + "_active").define(name + " active", (Object)dfActive);
        ForgeConfigSpec.ConfigValue spawnWeight = builder.comment("This defines the spawn rate of the " + name + "s (default: " + dfWeight + ")").translation("cnb.configgui." + name + "_weight").define(name + " spawn weight", (Object)dfWeight);
        ForgeConfigSpec.ConfigValue biomes = builder.comment("This defines which biomes the " + name + "s will spawn in").translation("cnb.configgui." + name + "_biomes").defineList(name + " biomes", dfBiomes, o -> o instanceof String);
        return new EntityConfig((ForgeConfigSpec.ConfigValue<Boolean>)active, (ForgeConfigSpec.ConfigValue<Integer>)spawnWeight, (ForgeConfigSpec.ConfigValue<List<? extends String>>)biomes);
    }
}

